<?php
require_once '../config/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitize($_POST['username'] ?? '');
    $nama_lengkap = sanitize($_POST['nama_lengkap'] ?? '');
    $email = sanitize($_POST['email'] ?? '');
    $no_hp = sanitize($_POST['no_hp'] ?? '');
    $no_ktp = sanitize($_POST['no_ktp'] ?? '');
    $provinsi = sanitize($_POST['provinsi'] ?? '');
    $kabupaten = sanitize($_POST['kabupaten'] ?? '');
    $kelurahan = sanitize($_POST['kelurahan'] ?? '');
    $dusun_id = intval($_POST['dusun_id'] ?? 0);
    $rt = sanitize($_POST['rt'] ?? '');
    $rw = sanitize($_POST['rw'] ?? '');
    $password = $_POST['password'] ?? '';
    $password_confirm = $_POST['password_confirm'] ?? '';
    
    // Validation
    if (empty($username) || empty($nama_lengkap) || empty($password) || empty($no_ktp)) {
        $_SESSION['error'] = 'Data wajib (Username, Nama Lengkap, No. KTP, Password) harus diisi';
        redirect('../index.php');
    }
    
    // Validate KTP (16 digits)
    if (!empty($no_ktp) && (strlen($no_ktp) < 16 || strlen($no_ktp) > 16 || !is_numeric($no_ktp))) {
        $_SESSION['error'] = 'Nomor KTP harus 16 digit angka';
        redirect('../index.php');
    }
    
    if (strlen($password) < PASSWORD_MIN_LENGTH) {
        $_SESSION['error'] = 'Password minimal ' . PASSWORD_MIN_LENGTH . ' karakter';
        redirect('../index.php');
    }
    
    if ($password !== $password_confirm) {
        $_SESSION['error'] = 'Password dan konfirmasi password tidak sama';
        redirect('../index.php');
    }
    
    $db = Database::getInstance()->getConnection();
    
    // Check if username exists
    $stmt = $db->prepare("SELECT id FROM users WHERE username = ?");
    $stmt->execute([$username]);
    if ($stmt->fetch()) {
        $_SESSION['error'] = 'Username sudah digunakan';
        redirect('../index.php');
    }
    
    // Check if KTP already exists
    if (!empty($no_ktp)) {
        $stmt = $db->prepare("SELECT id FROM users WHERE no_ktp = ?");
        $stmt->execute([$no_ktp]);
        if ($stmt->fetch()) {
            $_SESSION['error'] = 'Nomor KTP sudah terdaftar';
            redirect('../index.php');
        }
    }
    
    // Get GPS coordinates if provided
    $latitude = floatval($_POST['latitude'] ?? 0);
    $longitude = floatval($_POST['longitude'] ?? 0);
    
    // Create user (only warga can register)
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $db->prepare("INSERT INTO users (username, password, nama_lengkap, email, no_hp, no_ktp, provinsi, kabupaten, kelurahan, dusun_id, rt, rw, latitude, longitude, role) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'warga')");
    
    if ($stmt->execute([$username, $hashed_password, $nama_lengkap, $email, $no_hp, $no_ktp, $provinsi, $kabupaten, $kelurahan, $dusun_id > 0 ? $dusun_id : null, $rt, $rw, $latitude, $longitude])) {
        // Auto login after registration
        $user_id = $db->lastInsertId();
        $_SESSION['user_id'] = $user_id;
        $_SESSION['username'] = $username;
        $_SESSION['nama_lengkap'] = $nama_lengkap;
        $_SESSION['user_role'] = 'warga';
        
        $_SESSION['success'] = 'Pendaftaran berhasil! Selamat datang.';
        redirect('../dashboard.php');
    } else {
        $_SESSION['error'] = 'Terjadi kesalahan saat mendaftar';
        redirect('../index.php');
    }
} else {
    redirect('../index.php');
}

